<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis profilu Výšky Stávající Navržené</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis profilu Výšky Stávající Navržené</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>

                                <table class="margin" width="60%">
                                    <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                                        <thead style="display:table-header-group">
                                            <tr>
                                                <td colspan="4" lang="en">
                                                    <strong>&#xa0; &#xa0; &#xa0; &#xa0; &#xa0; Název trasy:&#xa0; </strong>
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4" lang="en">
                                                    <strong>Trasa Popis:&#xa0; </strong>
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4" lang="en">
                                                    <strong>&#xa0; &#xa0; &#xa0; &#xa0; &#xa0; &#xa0;Trasa Styl:&#xa0; </strong>
                                                    <xsl:value-of select="@style"/>
                                                    <br/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">&#xa0;</td>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">Staničení</th>
                                                <th class="underline" lang="en">
                                                    Existující<br/>Z
                                                </th>
                                                <th class="underline" lang="en">
                                                    Navržený<br/>Z
                                                </th>
                                                <th class="underline" lang="en">
                                                    Zářez/Násyp<br/>Rozdíl
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                                                <xsl:variable name="cutFillDepth" select="centerLinePoint/point/@elevation - @existingGroundElevation"/>
                                                <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                                                    <tr>
                                                        <td colspan="4" lang="en">
                                                            <strong>
                                                                <br/>Odstup (Definovaný) Trasa: &#xa0;
                                                            </strong>
                                                            <xsl:value-of select="@offsetAlignmentName"/>
                                                            <br/>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                                <tr>
                                                    <td class="sidepad" align="right" nowrap="nowrap">
                                                        <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number(@existingGroundElevation))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:value-of select="cif:ordinateFormat(number(centerLinePoint/point/@elevation))"/>
                                                    </td>
                                                    <td class="sidepad" align="right">
                                                        <xsl:choose>
                                                            <xsl:when test="$cutFillDepth &lt; 0">
                                                                <xsl:value-of select="cif:ordinateFormat(number(-1 * $cutFillDepth))"/>
                                                                <xsl:text>&#xa0; C</xsl:text>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:value-of select="cif:ordinateFormat(number($cutFillDepth))"/>
                                                                <xsl:text>&#xa0; F</xsl:text>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body ve staničení a odstupu buď pomocí <em>
                    Nástroje &gt; XML Výpisy &gt; Základní staničení
                </em> nebo <em>
                    Nástroje &gt; XML Výpisy &gt; Staničení Odstup
                </em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em> <em>Z</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte také vybrat stejné směrové řešení v listu <em>Směrová řešení</em> nebo prvek v 
                listu <em>Prvky</em>.&#xa0; Lepší výsledky můžete obdržet, pokud zkopírujete směrové řešení  
                u kterého chcete provést výpis, do povrchu jako netriangulovaný prvek a vybrat jej v záložce <em>Prvky</em> pro výpois existujících výšek.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> (<em>
                    Směrové body - Na trase, Významné, 
					Výškové body - Na trase, Významné
                </em> nebo <em>Interval</em>.)
            </p>
            <p class="normal1" lang="en">
                <em>Staničení Limity</em> použijte pouze na spočtená data, např. body pomocí Interval.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2013 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
